/***************************************************************
 * Name:      StepMania_Songs_listerMain.cpp
 * Purpose:   Code for Application Frame
 * Author:    BestSteve (ibmibmibm.tw@gmail.com)
 * Created:   2007-12-19
 * Copyright: BestSteve ()
 * License:   GPLv3
 **************************************************************/

#ifdef WX_PRECOMP
#include "wx_pch.h"
#endif

#ifdef __BORLANDC__
#pragma hdrstop
#endif //__BORLANDC__

#include "StepMania_Songs_listerMain.h"

//helper functions
enum wxbuildinfoformat {
    short_f, long_f };

wxString wxbuildinfo(wxbuildinfoformat format)
{
    wxString wxbuild(wxVERSION_STRING);

    if (format == long_f )
    {
#if defined(__WXMSW__)
        wxbuild << _T("-Windows");
#elif defined(__WXMAC__)
        wxbuild << _T("-Mac");
#elif defined(__UNIX__)
        wxbuild << _T("-Linux");
#endif

#if wxUSE_UNICODE
        wxbuild << _T("-Unicode build");
#else
        wxbuild << _T("-ANSI build");
#endif // wxUSE_UNICODE
    }

    return wxbuild;
}

BEGIN_EVENT_TABLE(StepMania_Songs_listerFrame, wxFrame)
    EVT_SIZE(StepMania_Songs_listerFrame::OnSize)
    EVT_CLOSE(StepMania_Songs_listerFrame::OnClose)
    EVT_BUTTON(idBtnQuit, StepMania_Songs_listerFrame::OnQuit)
    EVT_BUTTON(idBtnAbout, StepMania_Songs_listerFrame::OnAbout)
    EVT_BUTTON(idBtnSelectPath, StepMania_Songs_listerFrame::OnSelectPath)
    EVT_BUTTON(idBtnProccess, StepMania_Songs_listerFrame::OnProccess)
END_EVENT_TABLE()

StepMania_Songs_listerFrame::StepMania_Songs_listerFrame(wxFrame *frame, const wxString &title)
    : wxFrame(frame, -1, title)
{
    this->SetSizeHints(wxDefaultSize, wxDefaultSize);

    m_MainSizer = new wxBoxSizer(wxVERTICAL);

    {
        wxBoxSizer* bDirSizer;
        bDirSizer = new wxBoxSizer(wxHORIZONTAL);
        m_stepmania_path_label = new wxStaticText(this, wxID_ANY, _("StepMania Directory:"));
        bDirSizer->Add(m_stepmania_path_label, 0, wxALIGN_CENTER, 5);

        m_stepmania_path = new wxTextCtrl(this, wxID_ANY, wxFileName::GetHomeDir(), wxDefaultPosition, wxDefaultSize);
        bDirSizer->Add(m_stepmania_path, 1, wxALL|wxEXPAND, 5);

        BtnSelectPath = new wxButton(this, idBtnSelectPath, _(".."), wxDefaultPosition, wxDefaultSize, 0);
        bDirSizer->Add(BtnSelectPath, 0, wxALL, 5);

        BtnProccess = new wxButton(this, idBtnProccess, _("&Proccess"), wxDefaultPosition, wxDefaultSize, 0);
        bDirSizer->Add(BtnProccess, 0, wxALL, 5);

        m_MainSizer->Add(bDirSizer, 0, wxALL|wxEXPAND, 5);
    }

    {
        m_output_result = new wxTextCtrl(this, wxID_ANY, wxEmptyString, wxDefaultPosition, wxDefaultSize, wxTE_MULTILINE);

        m_MainSizer->Add(m_output_result, 1, wxALL|wxEXPAND, 5);
    }

    {
        wxBoxSizer* bBtnSizer;
        bBtnSizer = new wxBoxSizer(wxHORIZONTAL);

        BtnAbout = new wxButton(this, idBtnAbout, _("&About"), wxDefaultPosition, wxDefaultSize, 0);
        bBtnSizer->Add(BtnAbout, 0, wxALL, 5);

        m_staticline1 = new wxStaticLine(this, wxID_ANY, wxDefaultPosition, wxDefaultSize, wxLI_VERTICAL);
        bBtnSizer->Add(m_staticline1, 0, wxALL|wxEXPAND, 5);

        BtnQuit = new wxButton(this, idBtnQuit, _("&Quit"), wxDefaultPosition, wxDefaultSize, 0);
        bBtnSizer->Add(BtnQuit, 0, wxALL, 5);

        m_MainSizer->Add(bBtnSizer, 0, wxALIGN_RIGHT, 5);
    }

    this->SetSizer(m_MainSizer);
    this->Layout();
    m_MainSizer->Fit(this);
}

StepMania_Songs_listerFrame::~StepMania_Songs_listerFrame()
{
}

void StepMania_Songs_listerFrame::OnClose(wxCloseEvent &event)
{
    Destroy();
}

void StepMania_Songs_listerFrame::OnQuit(wxCommandEvent &event)
{
    Destroy();
}
void StepMania_Songs_listerFrame::OnSize(wxSizeEvent &event)
{
    this->Layout();
}

void StepMania_Songs_listerFrame::OnAbout(wxCommandEvent &event)
{
    wxString msg(_(
        "StepMania Songs Lister Version 0.01\n"
        "Copyright (C) 2007 BestSteve.\n"
        "This program is free software, "
            "covered by the GNU General Public License version 3, "
            "and you are welcome to change it and/or distribute copies of it "
            "under certain conditions.\n"
        "There is absolutely no warranty for this program.\n"));
    msg += wxbuildinfo(long_f);
    wxMessageBox(msg, _("About StepMania Songs Lister..."));
}

void StepMania_Songs_listerFrame::OnSelectPath(wxCommandEvent &event)
{
    wxDirDialog dialog(this, _("Choose a directory"), m_stepmania_path->GetValue());
    if (dialog.ShowModal() == wxID_OK)
    {
        m_stepmania_path->SetValue(dialog.GetPath());
    }
}

void StepMania_Songs_listerFrame::OnProccess(wxCommandEvent &event)
{
    wxString sm_path(m_stepmania_path->GetValue(), wxConvUTF8);
    wxDir sm_dir;

    if (!sm_dir.Open(sm_path))
    {
        return;
    }
    wxFileName sm_fn(sm_path, wxEmptyString);
    wxString catelog;
    if (sm_dir.GetFirst(&catelog, wxEmptyString, wxDIR_DIRS | wxDIR_HIDDEN))
    {
        wxString list, tmp;
        do
        {
            wxFileName catelog_fn(sm_fn);
            catelog_fn.AppendDir(catelog);
            wxDir catelog_dir;
            catelog_dir.Open(catelog_fn.GetPath());
            wxString song;
            if (catelog_dir.GetFirst(&song, wxEmptyString, wxDIR_DIRS | wxDIR_HIDDEN))
            {
                tmp.Printf(_("Catelog: %s\n"), catelog.c_str());
                list += tmp;
                do
                {
                    wxFileName song_fn(catelog_fn);
                    song_fn.AppendDir(song);
                    wxDir song_dir;
                    song_dir.Open(song_fn.GetPath());
                    wxString sm;
                    if (song_dir.GetFirst(&sm, wxT("*.sm"), wxDIR_FILES | wxDIR_HIDDEN))
                    {
                        song_fn.SetFullName(sm);
                        wxFFile sm_file;
                        if (sm_file.Open(song_fn.GetFullPath().c_str()))
                        {
                            char buffer[1024];
                            while (fgets(buffer, 1024, sm_file.fp()))
                            {
                                wxString rest, line(buffer, wxConvUTF8);
                                line = line.AfterFirst(wxT('#')).BeforeLast(wxT(';'));
                                if (line.StartsWith(wxT("TITLE:"), &rest))
                                {
                                    tmp.Printf(_("Title: %s\nDirName: %s\n"), rest.c_str(), song.c_str());
                                    list += tmp;
                                    break;
                                }
                            }
                            sm_file.Close();
                        }
                        else
                        {
                            tmp.Printf(_("Dirname: %s\n"), song.c_str());
                            list += tmp;
                        }
                    }
                } while (catelog_dir.GetNext(&song));
            }
            m_output_result->SetValue(list);
        } while (sm_dir.GetNext(&catelog));
    }
}
